/**
 * \file: mspin_connection_tls_server.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * mySPIN Connection Adapter TCP/IP
 *
 * \component: MSPIN
 *
 * \author: Thilo Bjoern Fickel BSOT/PJ-ES1 thilo.fickel@bosch-softtec.com
 *
* \copyright: (c) 2016 Bosch SoftTec GmbH
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

#ifndef MSPIN_CONNECTION_TLS_SERVER_H_
#define MSPIN_CONNECTION_TLS_SERVER_H_

#include "mspin_typedef.h"

#include <openssl/ssl.h>    //SSL_CTX

typedef struct
{
    char *certFile;
    char *keyFile;
    char *caFile;
    bool verifyClient;
    bool limitToAES256;
    SSL_CTX* pSSLContext;
} mspin_tls_parameter_t; //will be created once per listener

void mspin_tls_initTLS(void);

void mspin_tls_deinitTLS(void);

mspin_tls_parameter_t* mspin_tls_createContext(void);

void mspin_tls_deleteContext(mspin_tls_parameter_t** ppTLSContext);

MSPIN_ERROR mspin_tls_setParameter(mspin_tls_parameter_t* pTLSContext, MSPIN_TLS_CONFIGURATION_t* pTLSConfig);

MSPIN_ERROR mspin_tls_createSSLContext(mspin_tls_parameter_t* pTLSContext);

MSPIN_ERROR mspin_tls_deleteSSLContext(mspin_tls_parameter_t* pTLSContext);

MSPIN_ERROR mspin_tls_configureSSLContext(mspin_tls_parameter_t* pTLSContext);

MSPIN_ERROR mspin_tls_connectClient(mspin_context_t* pContext, S32 connectionID);

S32 mspin_tls_receive(mspin_connectionHandle_t *pConnectionHandle, U8* buffer, U32 bufferLen, U32 timeout);

S32 mspin_tls_send(mspin_connectionHandle_t *pConnectionHandle, const U8* buffer, U32 bufferLen);

#endif /* MSPIN_CONNECTION_TLS_SERVER_H_ */
